/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.formatter;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.formatter.MarkdownWriter;
import icyllis.flexmark.formatter.NodeFormatterContext;
import icyllis.flexmark.formatter.NodeFormattingHandler;
import icyllis.flexmark.util.ast.Node;
import java.io.IOException;
import java.util.List;

public abstract class NodeFormatterSubContext
implements NodeFormatterContext {
    protected final MarkdownWriter markdown;
    Node renderingNode;
    List<NodeFormattingHandler<?>> rendererList = null;
    int rendererIndex = -1;

    public NodeFormatterSubContext(@NotNull MarkdownWriter markdown) {
        this.markdown = markdown;
        this.renderingNode = null;
    }

    @Nullable
    public Node getRenderingNode() {
        return this.renderingNode;
    }

    public void setRenderingNode(@Nullable Node renderingNode) {
        this.renderingNode = renderingNode;
    }

    @Override
    @NotNull
    public MarkdownWriter getMarkdown() {
        return this.markdown;
    }

    public void flushTo(@NotNull Appendable out, int maxTrailingBlankLines) {
        this.flushTo(out, this.getFormatterOptions().maxBlankLines, maxTrailingBlankLines);
    }

    public void flushTo(@NotNull Appendable out, int maxBlankLines, int maxTrailingBlankLines) {
        this.markdown.line();
        try {
            this.markdown.appendTo(out, maxBlankLines, maxTrailingBlankLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

